from ultralytics import YOLO
import yaml
import os

with open("config.yaml", "r") as file:
    config = yaml.safe_load(file)

# Define the path to the dataset configuration file
dataset_config_path = os.path.join(config["path_to_datasets"],config["train_dataset"])

# Initialize the YOLO model
model = YOLO(config["model"])

# Train the model
train_results = model.train(data=dataset_config_path, epochs=config['epochs'], imgsz=config['img_size'],
                            batch=config['batch_size'], patience= config["patience"])
